<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once '../includes/config.php';

try {
    $response = [
        'database' => ['status' => 'error', 'message' => ''],
        'tables' => ['status' => 'error', 'message' => '']
    ];
    
    // Verificar se arquivo de configuração existe
    if (!file_exists('../config/database.json')) {
        $response['database'] = [
            'status' => 'warning',
            'message' => 'Configuração do banco não encontrada'
        ];
        echo json_encode($response);
        exit;
    }
    
    // Carregar configuração
    $config = json_decode(file_get_contents('../config/database.json'), true);
    
    if (!$config) {
        $response['database'] = [
            'status' => 'error',
            'message' => 'Erro ao ler configuração do banco'
        ];
        echo json_encode($response);
        exit;
    }
    
    // Testar conexão
    try {
        $pdo = new PDO(
            "mysql:host={$config['host']};dbname={$config['dbname']};charset=utf8mb4",
            $config['username'],
            $config['password'],
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
        
        $response['database'] = [
            'status' => 'success',
            'message' => 'Conexão estabelecida com sucesso'
        ];
        
        // Verificar tabelas necessárias
        $tabelasNecessarias = [
            'Associados', 'Endereco', 'Militar', 'Contrato', 
            'Redes_sociais', 'Financeiro', 'Auditoria'
        ];
        
        $tabelasEncontradas = [];
        $tabelasFaltando = [];
        
        foreach ($tabelasNecessarias as $tabela) {
            $stmt = $pdo->query("SHOW TABLES LIKE '$tabela'");
            if ($stmt->rowCount() > 0) {
                $tabelasEncontradas[] = $tabela;
            } else {
                $tabelasFaltando[] = $tabela;
            }
        }
        
        if (empty($tabelasFaltando)) {
            $response['tables'] = [
                'status' => 'success',
                'message' => count($tabelasEncontradas) . ' tabelas encontradas'
            ];
        } else {
            $response['tables'] = [
                'status' => 'warning',
                'message' => 'Faltam ' . count($tabelasFaltando) . ' tabelas: ' . implode(', ', $tabelasFaltando)
            ];
        }
        
        // Informações adicionais
        $stmt = $pdo->query("SELECT COUNT(*) as total FROM Associados");
        $totalAssociados = $stmt->fetch()['total'];
        
        $response['info'] = [
            'total_associados' => $totalAssociados,
            'tabelas_encontradas' => $tabelasEncontradas,
            'tabelas_faltando' => $tabelasFaltando
        ];
        
    } catch (PDOException $e) {
        $response['database'] = [
            'status' => 'error',
            'message' => 'Erro de conexão: ' . $e->getMessage()
        ];
    }
    
} catch (Exception $e) {
    $response = [
        'database' => ['status' => 'error', 'message' => 'Erro geral: ' . $e->getMessage()],
        'tables' => ['status' => 'error', 'message' => 'Não foi possível verificar']
    ];
}

echo json_encode($response);
?>